'use strict';_={_:` Execute Javascript code as a script inside a webpage or as a <br> <a doc href="${_Ce.scrtDoc}/background-scripts">background script</a>.\n This allows you to interact with webpages, <br> perform operations with your open tabs, read and save files <br>\n to your hard drive, manipulate the contents of the clipboard, <br> among many other things. <hr b=2>\n Learn more at the <a href="${_Ce.scrtDoc}">Scripting documentation</a>. <hr b=3>\n <b>Limitation:</b> Scripts cannot run in <c h=/protPg>protected pages</c>.\n `,
name:" If you give this script a name, it'll be added to the list of <br> existing scripts, so you can use it on other actions as well. <hr b=2>\n Also, scripts with a name can be called programmatically <br> from other scripts using the <apiRef runInTab> function.\n ",bkgr:` You have the option to run a script either in the background or in <br> one or more webpages (the <c h=/actions/tgtTabs>target tabs</c>). <hr b>\n Since a background script is not tied to any webpage, it can run <br> indefinitely. Whereas a script that runs in a webpage\n is terminated <br> as soon as the browser unloads that page (when you close the <br> tab or navigate to another page). <hr b=2>\n Learn more at <a href="${_Ce.scrtDoc}/background-scripts">Background Scripts</a>.\n `,
asyn:" By default, scripts run <u>synchronously</u>, i.e. AutoControl will wait for a script <br> to finish before doing anything else.\n During this wait period, triggers and <br> shortcuts will not respond immediately;\n instead, they'll be enqueued until <br> the script is finished. <hr b>\n So, if your script takes too long to finish, you should run it <u>asynchronously</u>. <br> That way, AutoControl will not wait for it to finish,\n and all your triggers and <br> shortcuts will keep responding while the script is running. <hr b>\n However, you must run a script <u>synchronously</u> if successive actions depend <br> on what the script did.\n For example, when <c h=/actions/actChain>chaining</c> actions together: <hr b=4>\n <center><mid><act>run script</act> <sep></sep> <act>activate tabs</act></mid></center>\n ",
file:` You can specify the <c h=/fsPath>absolute path</c> or <c h=/url>URL</c> of a file. This file must <br> contain the script you want to execute. <br>\n If you specify a local file path, that file can be edited directly in the <br> text box below.\n You can also edit the file with your preferred code <br> editor, such as VSCode, Notepad++, etc. <hr b=2>\n You can include <a doc href="${_Ce.scrtDoc}/location-placeholders">location placeholders</a> in the path.\n The drop-down <br> menu shows the most commonly used placeholders. <hr b=2>\n More about this subject at <a href="${_Ce.scrtDoc}/script-location">Script Location</a>.\n <!--\n You can either enter your script's source code in the text box <br> below\n or you can specify a local file or URL from which to get <br> the source code. <hr b>\n If you specify a local file, that file can be edited in the text box <br> below or in an external code editor, however you prefer. <hr b=2>\n More details about this at <a href="${_Ce.scrtDoc}/script-location">Script Location</a>.\n -->\n `,
run:' Use this button to quickly test your script in the given page or in <br> the background. <hr b>\n This is just for testing purposes. The actual pages the script will run <br> in when the <act inln>run script</act>\n action is executed are determined by the <br> <c h=/actions/tgtTabs>target tabs</c>.\n Unless you chose the option "run in <c h=@/bkgr>background</c>", in <br> which case there are no target tabs. <hr b=2>\n You can open the DevTools console in the target tab to see any <br> errors thrown by your script.\n For background scripts, go <a href="chrome://inspect/#extensions">here</a> and <br> then "inspect" AutoControl. <hr b=2>\n Also, remember that scripts cannot run in <c h=/protPg>protected pages</c>.\n '};
